#########################################################
#            AVSMaker Professional Edition              #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################

use strict;

sub	submit_vip {
	my ($acct, @cats) = @_;

	my $numpics;
	map { scalar(@{$used{content}}) >= $_ and $numpics = $_ } (100, 150, 200, 200, 250, 300, 350, 351);
	wrn("Not enough pics for VIP-ID"), return if !$numpics;
	my $params = 	"psACCOUNT_ID=${$acct}[2]".
			join("", map { "&psCategoryArray=${$cats[$_]}[0]" } 1..2).
			"&psNAME=$cf{sitename}".
			"&psKEYWORDS=" . join(" ", @{$cf{keywords}}).
			"&psDESCRIPTION=$cf{descr}".
			"&psPRE_AUTH_URL=http://$cf{baseurl}/$cf{dir}/$cf{avsdir}/$cf{entrypage}.$cf{htmlext}".
			"&psPOST_AUTH_URL=http://$cf{baseurl}/$cf{dir}/$cf{avsdir}/$cf{memarea}".
			"&psPICTURE_COUNT=$numpics".
			"&psLIVE_VIDEO_COUNT=0".
			"&psVIDEO_FILE_COUNT=0".
			"&psSTORY_COUNT=0".
			"&psONLINE_STORE_FLAG=N";
	
	my $out = gethttp({
		host	=> "www.vip-id.com",
		file	=> "/app/frmSite.Submit",
		method	=> "POST",
		ua	=> $cf{ua},
		params	=> $params,
		cookie	=> ${$acct}[4],
	});

	wrn("Error occurred during VIP-ID site submission"), return
		if $out =~ /Unexpected Error/;	

	return gethttp({
		host	=> "www.vip-id.com",
		file	=> "/app/frmSiteList.Open",
		method	=> "GET",
		ua	=> $cf{ua},
		params	=> "psACCOUNT_ID=${$acct}[2]&psREPORT_TYPE=6",
		referer	=> "http://www.vip-id.com/app/frmSiteList.Open",
		cookie	=> ${$acct}[4],
		pat	=> 'psSITE_ID=(\d+)\D',
		max	=> 1,
	});
}

sub	init_vip {
	# log in to VIP-ID
	my $acct = shift;
	my $params =	"psURL=%2Fapp%2FfrmSiteList.Open".
			"&psUSERNAME=". ${$acct}[0] .
			"&psPASSWORD=". ${$acct}[1];
	my ($content, $headers) = gethttp({
		host	=> "www.vip-id.com",
		file	=> "/app/frmLogin.Submit",
		params	=> $params,
		method	=> "post",
		ua	=> $cf{ua},
	});

	${$acct}[4] = (split(/[:;]+\s*/, (grep { /^set-cookie/i } split(/\n/, $headers))[0]))[1];
	return if !${$acct}[4];
	
	${$acct}[2] = gethttp({
		host	=> "www.vip-id.com",
		file	=> "/app/frmSiteList.Open",
		cookie	=> ${$acct}[4],
		ua	=> $cf{ua},
		pat	=> 'psACCOUNT_ID=(\d+)',
	}) or err("Could not parse real user ID?")
	if (!${$acct}[2]);
}

"vip";
